<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'nevo_customizer_single_related_posts_config' ) ) {
	function nevo_customizer_single_related_posts_config( $configs = array() ) {

		$panel    = 'blog_panel';
		$section  = 'post_related';
		$selector = '.single-after-entry';
		$cb       = 'nevo_display_post_single_elements';
		$config = array(
			
			array(
				'name'  => 'post_related',
				'type'  => 'section',
				'panel' => $panel,
				'priority' => 65,
				'title' => __( 'Single Related Posts', 'nevo' ),
			),
			
			array(
				'name'            => $section . '_title',
				'type'            => 'text',
				'section'         => $section,
				'selector'        => $selector,
				'render_callback' => $cb,
				'default'         => __( 'Related Posts', 'nevo' ),
				'label'           => __( 'Title', 'nevo' ),
			),
			
			array(
				'name'            => $section . '_col',
				'type'            => 'select',
				'section'         => $section,
				'default'         => array(
					'desktop' => 3,
					'tablet'  => 2,
					'mobile'  => 1,
				),
				'device_settings' => true,
				'selector'        => $selector,
				'render_callback' => $cb,
				'label'           => __( 'Number columns to show', 'nevo' ),
				'choices'         => array(
					1 => 1,
					2 => 2,
					3 => 3,
					4 => 4,
				),
			),

			array(
				'name'            => $section . '_by',
				'type'            => 'select',
				'section'         => $section,
				'default'         => 'cat',
				'max'             => 150,
				'selector'        => $selector,
				'render_callback' => $cb,
				'label'           => __( 'Related posts by', 'nevo' ),
				'choices'         => array(
					'cat' => __( 'By categories', 'nevo' ),
					'tag' => __( 'By tags', 'nevo' ),
				),
			),
			
			array(
				'name'            => $section . '_orderby',
				'type'            => 'select',
				'section'         => $section,
				'selector'        => $selector,
				'render_callback' => $cb,
				'label'           => __( 'Order by', 'nevo' ),
				'default'         => 'date',
				'choices'         => array(
					'date'          => __( 'Date', 'nevo' ),
					'title'         => __( 'Title', 'nevo' ),
					'menu_order'    => __( 'Post order', 'nevo' ),
					'rand'          => __( 'Random', 'nevo' ),
					'comment_count' => __( 'Comment count', 'nevo' ),
				),
			),

			array(
				'name'            => $section . '_order',
				'type'            => 'select',
				'section'         => $section,
				'selector'        => $selector,
				'render_callback' => $cb,
				'default'         => 'desc',
				'label'           => __( 'Order', 'nevo' ),
				'choices'         => array(
					'desc' => __( 'Desc', 'nevo' ),
					'asc'  => __( 'Asc', 'nevo' ),
				),
			),
			
			array(
				'name'            => $section . '_number',
				'type'            => 'text',
				'section'         => $section,
				'selector'        => $selector,
				'default'         => 3,
				'render_callback' => $cb,
				'label'           => __( 'Number posts to show', 'nevo' ),
				'description'     => __( 'Enter 0 to disable related posts.', 'nevo' ),
			),

			array(
				'name'    => $section . '_h_content',
				'type'    => 'heading',
				'section' => $section,
				'title'   => __( 'Title / Meta / Excerpt', 'nevo' ),
			),
			
			array(
				'name'        => $section . '_typography',
				'type'        => 'typography',
				'section'     => $section,
				'title'       => __( 'Post Title Typography', 'nevo' ),
				'css_format'  => 'typography',
				'selector'    => "{$selector} .entry-title",
				'fields'      => array(
					'font'      		=> false,
					'font_weight'    	=> false,
					'style' 			=> false,
					'text_decoration' 	=> false,
					'text_transform' 	=> false,
					'languages' 		=> false,
					'line_height'    	=> false,
					'letter_spacing' 	=> false,
				),
			),
			
			array(
				'name'            => $section . '_display_post_categories',
				'type'            => 'checkbox',
				'section'         => $section,
				'selector'        => $selector,
				'default'         => 1,
				'render_callback' => $cb,
				'title'  		  => __( 'Display post categories', 'nevo' ),
			),
			
			array(
				'name'            => $section . '_display_post_avatar',
				'type'            => 'checkbox',
				'section'         => $section,
				'default'         => 0,
				'selector'        => $selector,
				'render_callback' => $cb,
				'checkbox_label'  => __( 'Show author avatar', 'nevo' ),
			),
			
			array(
				'name'            => $section . '_display_post_author',
				'type'            => 'checkbox',
				'section'         => $section,
				'selector'        => $selector,
				'default'         => 0,
				'render_callback' => $cb,
				'title'  		  => __( 'Display post author', 'nevo' ),
			),
			
			array(
				'name'            => $section . '_display_post_date',
				'type'            => 'checkbox',
				'section'         => $section,
				'selector'        => $selector,
				'default'         => 0,
				'render_callback' => $cb,
				'title'  		  => __( 'Display post date', 'nevo' ),
			),
			
			array(
				'name'            => $section . '_display_post_comment',
				'type'            => 'checkbox',
				'section'         => $section,
				'selector'        => $selector,
				'default'         => 0,
				'render_callback' => $cb,
				'title'  		  => __( 'Display comment cout', 'nevo' ),
			),
			
			array(
				'name'            => $section . '_excerpt_length',
				'type'            => 'text',
				'section'         => $section,
				'selector'        => $selector,
				'default'         => 0,
				'render_callback' => $cb,
				'label'           => __( 'Excerpt length', 'nevo' ),
				'description'     => __( 'Custom excerpt length. Enter 0 to hide the excerpt.', 'nevo' ),
			),
			
			array(
				'name'    => $section . '_h_related',
				'type'    => 'heading',
				'section' => $section,
				'title'   => __( 'Cusstom Media', 'nevo' ),
			),
			
			array(
				'name'            => $section . '_img_pos',
				'type'            => 'radio_group',
				'section'         => $section,
				'default'         => 'aligncenter',
				'selector'        => $selector,
				'render_callback' => $cb,
				'label'           => __( 'Image Position', 'nevo' ),
				'choices'         => array(
					'alignleft'   => __( 'Left', 'nevo' ),
					'aligncenter' => __( 'Center', 'nevo' ),
					'alignright'  => __( 'Right', 'nevo' ),
				),
			),

			array(
				'name'            => $section . '_thumbnail_width',
				'type'            => 'slider',
				'section'         => $section,
				'selector'        => 'format',
				'unit'            => '%',
				'max'             => '100',
				'default'         => '',
				'label'           => __( 'Custom Thumbnail Width', 'nevo' ),
				'device_settings' => true,
				'css_format'      => '.related-posts .post-image img { flex-basis: {{value_no_unit}}%; width: {{value_no_unit}}%; }',
			),

			array(
				'name'            => $section . '_thumbnail_size',
				'type'            => 'select',
				'section'         => $section,
				'selector'        => $selector,
				'render_callback' => $cb,
				'default'         => 'medium',
				'label'           => __( 'Thumbnail Size', 'nevo' ),
				'choices'         => array_merge(
					array(
						'disable'	=> __( 'Disable', 'nevo' ),
					),
					nevo_blog_get_image_sizes()
				),
			),

		);

		return array_merge( $configs, $config );

	}
}

add_filter( 'nevo/customizer/config', 'nevo_customizer_single_related_posts_config', 399 );

