<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'nevo_customizer_section_config' ) ) {
	function nevo_customizer_section_config($configs = array()) {
		$section  = 'section_1';
		$name     = 'section_1';
		$selector = ".section-frontpage";
		$config   = array(
			array(
				'name'     => 'frontpage_panel',
				'type'     => 'panel',
				'priority' => 15,
				'title'    => __( 'Frontpage', 'nevo' ),
				//'active_callback' => 'nevo_showon_frontpage'
			),
			array(
				'name'     => $section,
				'type'     => 'section',
				'panel'    => 'frontpage_panel',
				'priority' => 50,
				'title'    => __( 'Section', 'nevo' ),
			),
			
			array(
				'name'            => $name . '_menu_highlight',
				'type'            => 'select',
				'section'         => $section,
				'title'           => __( 'Top level menu items highlight', 'nevo' ),
				'selector'        => $selector,
				'css_format'      => 'html_class',
				'default'         => 'highlight-menu-normal',
				'choices'         => array(
					'highlight-menu-normal' 		 => __( 'None', 'nevo' ),
					'highlight-menu-color'       => __( 'Color', 'nevo' ),
					'highlight-menu-border'      => __( 'Border', 'nevo' ),
					'highlight-menu-background'  => __( 'Background', 'nevo' ),
				),
				'priority' 		  => 70,
			),

			array(
				'name'             => $name . '_items',
				'type'             => 'repeater',
				'section'          => $section,
				'selector'         => $selector,
				'render_callback' => 'nevo_refresh_section_partials',
				'title'            => __( 'Columns Item', 'nevo' ),
				'live_title_field' => 'title',
				'active_callback' => 'nevo_showon_frontpage',
				'default'          => array(
					array(
						'title' => 'Facebook',
						'url'   => '#',
						'type'  => 'icon',
						'icon'  => array(
							'type' => 'bootstrap-icons',
							'icon' => 'bi-facebook',
						),
						'size'  => array(
							'unit' => 'px',
							'value' => '16',
						),
					),
					array(
						'title' => 'Twitter',
						'url'   => '#',
						'type'  => 'icon',
						'icon'  => array(
							'type' => 'bootstrap-icons',
							'icon' => 'bi-twitter',
						),
						'size'  => array(
							'unit' => 'px',
							'value' => '16',
						),
					),
					array(
						'title' => 'Pinterest',
						'url'   => '#',
						'type'  => 'icon',
						'icon'  => array(
							'type' => 'bootstrap-icons',
							'icon' => 'bi-pinterest',
						),
						'size'  => array(
							'unit' => 'px',
							'value' => '16',
						),
					),
				),
				'fields'           => array(
					array(
						'name'  => 'title',
						'type'  => 'text',
						'label' => __( 'Title', 'nevo' ),
					),
					
					array(
						'name'  => 'description',
						'type'  => 'textarea',
						'label' => __( 'Description', 'nevo' ),
					),

					array(
						'name'  => 'url',
						'type'  => 'text',
						'label' => __( 'URL', 'nevo' ),
					),
					
					array(
						'name'     => 'type',
						'type'     => 'select',
						'label'    => __( 'Icon Type', 'nevo' ),
						'choices'  => array(
							'icon' => __( 'Icon', 'nevo' ),
							'image' => __( 'Image', 'nevo' ),
						),
					),
					
					array(
						'name'  => 'icon',
						'type'  => 'icon',
						'label' => __( 'Icon', 'nevo' ),
						'required' => array( 'type', '==', 'icon' ),
					),
					
					array(
						'name'       => 'image',
						'type'       => 'image',
						'label'      => __( 'Image', 'nevo' ),
						'required'   => array( 'type', '==', 'image' ),
					),
					
					array(
						'name'            => 'size',
						'type'            => 'slider',
						'device_settings' => false,
						'min'             => 1,
						'step'            => 1,
						'max'             => 200,
						'default'         => 16,
						'label'           => __( 'Size', 'nevo' ),
					),
				),
			),

			array(
				'name'            => $name . '_target',
				'type'            => 'checkbox',
				'section'         => $section,
				'selector'        => $selector,
				'default'         => 1,
				'render_callback' => 'nevo_refresh_section_partials',
				'checkbox_label'  => __( 'Open link in a new tab.', 'nevo' ),
			),
			array(
						'name'     => 'type',
						'section'         => $section,
						'type'     => 'select',
						'label'    => __( 'Icon Type', 'nevo' ),
						'choices' => array_reduce(
							get_pages(), // lấy danh sách các trang của website
							function ($choices, $page) { // với mỗi trang, tạo một giá trị và nhãn tương ứng
								$choices[$page->post_name] = $page->post_title;
								return $choices;
							},
							array( __( 'Select page.', 'nevo' ) ) // mảng rỗng để bắt đầu
						),
					),
			
			array(
				'name'            => $name . '_label',
				'type'            => 'checkbox',
				'default'         => array(
					'desktop' => 0,
					'tablet'  => 0,
					'mobile'  => 0,
				),
				'section'         => $section,
				'selector'        => $selector,
				'device_settings' => true,
				'render_callback' => 'nevo_refresh_section_partials',
				'label'           => __( 'Show Icon Label?', 'nevo' ),
				'checkbox_label'  => __( 'Show Icon Label?', 'nevo' ),
			),
			
			array(
				'name'       => $name . '_setting',
				'type'       => 'modal',
				'section'    => $section,
				'selector'   => "{$selector} .social-icons",
				'css_format' => 'styling',
				'title'      => __( 'Icons Styling', 'nevo' ),
				'fields'     => array(
					'tabs'           => array(
						'default' => __( 'Normal', 'nevo' ),
						'hover'   => __( 'Hover', 'nevo' ),
					),
					'default_fields' => array(
						array(
							'name'       => $name . '_color',
							'type'       => 'color',
							'device_settings' => true,
							'label'      => __( 'Color', 'nevo' ),
							'selector'   => "$selector .social-icons",
							'css_format' => 'color: {{value}}; text-decoration-color: {{value}};',
						),
						array(
							'name'       => $name . '_bg_color',
							'type'       => 'color',
							'device_settings' => true,
							'label'      => __( 'Background Color', 'nevo' ),
							'selector'   => "$selector .social-icons",
							'css_format' => 'background-color: {{value}};',
						),
						
						array(
							'name'            => $name . '_padding',
							'type'            => 'css_ruler',
							'device_settings' => true,
							'selector'   	  => "$selector .social-icons",
							'css_format'      => array(
								'top'    => 'padding-top: {{value}};',
								'right'  => 'padding-right: {{value}};',
								'bottom' => 'padding-bottom: {{value}};',
								'left'   => 'padding-left: {{value}};',
							),
							'label'           => __( 'Padding', 'nevo' ),
						),
						
						array(
							'name'       => $name . '_border_radius',
							'type'       => 'css_ruler',
							'label'      => __( 'Border Radius', 'nevo' ),
							'selector'   => "{$selector} .social-icons",
							'css_format' => array(
								'top'    => 'border-top-left-radius: {{value}};',
								'right'  => 'border-top-right-radius: {{value}};',
								'bottom' => 'border-bottom-right-radius: {{value}};',
								'left'   => 'border-bottom-left-radius: {{value}};',
							),
						),
						
						array(
							'name'            => $name . '_spacing',
							'type'            => 'slider',
							'device_settings' => false,
							'section'         => $section,
							'min'             => 0,
							'max'             => 30,
							'default'         => 6,
							'selector'        => "$selector a+a",
							'css_format'      => 'margin-left: {{value}};',
							'label'           => __( 'Icon Spacing', 'nevo' ),
						),

					),
					'hover_fields'   => array(
						array(
							'name'       => $name . '_color',
							'type'       => 'color',
							'device_settings' => true,
							'label'      => __( 'Color', 'nevo' ),
							'selector'   => "$selector .social-icons:hover",
							'css_format' => 'color: {{value}}; text-decoration-color: {{value}};',
						),
						array(
							'name'       => $name . '_bg_color',
							'type'       => 'color',
							'device_settings' => true,
							'label'      => __( 'Background Color', 'nevo' ),
							'selector'   => "$selector .social-icons:hover",
							'css_format' => 'background-color: {{value}};',
						),
						
					),
				),
			),
		);
		return array_merge( $configs, $config );
	}
}
add_filter( 'nevo/customizer/config', 'nevo_customizer_section_config', 399 );