<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'nevo_customizer_styling_config' ) ) {

	function nevo_customizer_styling_config( $configs = array() ) {

		$config = array(

			array(
				'name'     => 'global_style',
				'type'     => 'section',
				'priority' => 20,
				'panel'    => 'general_panel',
				'title'    => __( 'Global Styles', 'nevo' ),
			),
			
			array(
				'name'       => 'outsite_background',
				'type'       => 'styling',
				'section'    => 'global_style',
				'title'      => __( 'Out Site Background', 'nevo' ),
				'selector'   => array(
					'normal' => 'body',
				),
				'default'   => array(
					'normal' => array(
						'bg_color' => '#f7f8f9',
					),
				),
				'css_format' => 'styling',
				'fields'     => array(
					'normal_fields' => array(
						'primary'	=> false,
						'secondary' => false,
						'success'	=> false,
						'info'	=> false,
						'warning'	=> false,
						'type_heading'	=> false,
						'link'	=> false,
						'link_hover'	=> false,
						'base'	=> false,
						'title'	=> false,
						'meta'	=> false,
						'heading'	=> false,
						'text_color'     => false,
						'link_color'     => false,
						'padding'        => false,
						'paddinga'    	 => false,
						'margin'         => false,
						'bg_heading' 	 => false,
						'border_heading' => false,
						'border_width'   => false,
						'border_color'   => false,
						'border_radius'  => false,
						'box_shadow'     => false,
						'border_style'   => false,
					),
					'hover_fields'  => false,
				),
				'required'   => array(
					array( 'site_layout', '=', 'nevo-container' ),
				),
			),
			
			array(
				'name'       => 'site_background',
				'type'       => 'styling',
				'section'    => 'global_style',
				'title'      => __( 'Site Background', 'nevo' ),
				'selector'   => array(
					'normal' => '.site',
				),
				'default'   => array(
					'normal' => array(
						'bg_color' => '#f7f8f9',
					),
				),
				'css_format' => 'styling',
				'fields'     => array(
					'normal_fields' => array(
						'primary'	=> false,
						'secondary' => false,
						'success'	=> false,
						'info'	=> false,
						'warning'	=> false,
						'type_heading'	=> false,
						'link'	=> false,
						'link_hover'	=> false,
						'base'	=> false,
						'title'	=> false,
						'meta'	=> false,
						'heading'	=> false,
						'text_color'     => false,
						'link_color'     => false,
						'padding'        => false,
						'paddinga'    	 => false,
						'margin'         => false,
						'bg_heading' 	 => false,
						'border_heading' => false,
						'border_width'   => false,
						'border_color'   => false,
						'border_radius'  => false,
						'box_shadow'     => false,
						'border_style'   => false,
					),
					'hover_fields'  => false,
				),
			),
			
			array(
				'name'       => 'content_styling',
				'type'       => 'styling',
				'section'    => 'global_style_none',
				'title'      => __( 'Content Background', 'nevo' ),
				'selector'   => array(
					'normal' => '.separate-containers .inside-article, .separate-containers .comments-area, .one-container .site-content, .separate-containers .paging-navigation, .separate-containers .single-after-entry > *',
				),
				'default'   => array(
					'normal' => array(
						'bg_color' => '#FFFFFF',
					),
				),
				'css_format' => 'styling',
				'fields'     => array(
					'normal_fields' => array(
						'primary'	=> false,
						'secondary' => false,
						'success'	=> false,
						'info'	=> false,
						'warning'	=> false,
						'type_heading'	=> false,
						'link'	=> false,
						'link_hover'	=> false,
						'base'	=> false,
						'title'	=> false,
						'meta'	=> false,
						'heading'	=> false,
						'padding'        => false,
						'paddinga'    	 => false,
						'margin'         => false,
						'text_color'     => false,
						'link_color'     => false,
						'bg_heading' 	 => false,
						'border_heading' => false,
						'border_width'   => false,
						'border_color'   => false,
						'border_radius'  => false,
						'box_shadow'     => false,
						'border_style'   => false,
					),
					'hover_fields'  => false,
				),
			),
			
			array(
				'name'       => 'button_styling',
				'type'       => 'styling',
				'section'    => 'global_style',
				'title'      => __( 'Button', 'nevo' ),
				'selector'   => array(
					'normal' => 'html button, html input[type="button"], html input[type="reset"], html input[type="submit"], html a.button, html a.button:visited, html a.wp-block-button__link:not(.has-background)',
					'hover' => 'html button:hover, html input[type="button"]:hover, html input[type="reset"]:hover, html input[type="submit"]:hover, html a.button:hover, html a.button:visited:hover, html a.wp-block-button__link:not(.has-background):hover',
					
				),
				'default'   => array(
					'normal' => array(
					),
				),
				'css_format' => 'styling',
				'fields'     => array(
					'normal_fields' => array(
						'primary'	=> false,
						'secondary' => false,
						'success'	=> false,
						'info'	=> false,
						'warning'	=> false,
						'type_heading'	=> false,
						'link'	=> false,
						'link_hover'	=> false,
						'base'	=> false,
						'title'	=> false,
						'meta'	=> false,
						'heading'	=> false,
						'link_color' 	 => false,
						'padding'        => false,
						'paddinga'    	 => false,
						'margin'         => false,
						//'bg_heading' 	 => false,
						//'bg_color' 		 => false,
						'bg_image' 		 => false,
						'box_shadow' => false,
					),
					'hover_fields' => array(
						'link_color' 	 => false,
						//'bg_heading' 	 => false,
						//'bg_color' 		 => false,
						'bg_image' 		 => false,
						'padding'        => false,
						'margin'         => false,
						'box_shadow' => false,
					),
				),
			),
			
			array(
				'name'       => 'form_input_styling',
				'type'       => 'styling',
				'section'    => 'global_style',
				'title'      => __( 'Form Input', 'nevo' ),
				'selector'   => array(
					'normal' => 'input[type="text"], input[type="email"], input[type="url"], input[type="password"], input[type="search"], input[type="number"], input[type="tel"], textarea, select',
					'hover' => 'input[type="text"]:focus, input[type="email"]:focus, input[type="url"]:focus, input[type="password"]:focus, input[type="search"]:focus, input[type="number"]:focus, input[type="tel"]:focus, textarea:focus, select:focus',
					
				),
				'default'   => array(
					'normal' => array(
					),
				),
				'css_format' => 'styling',
				'fields'     => array(
					'normal_fields' => array(
						'primary'	=> false,
						'secondary' => false,
						'success'	=> false,
						'info'	=> false,
						'warning'	=> false,
						'type_heading'	=> false,
						'link'	=> false,
						'link_hover'	=> false,
						'base'	=> false,
						'title'	=> false,
						'meta'	=> false,
						'heading'	=> false,
						'link_color' 	 => false,
						'padding'        => false,
						'paddinga'    	 => false,
						'margin'         => false,
						'bg_image' 		 => false,
						'box_shadow' => false,
					),
					'hover_fields' => array(
						'link_color' 	 => false,
						'bg_image' 		 => false,
						'padding'        => false,
						'margin'         => false,
					),
					'tabs'          => array(
						'normal' => __( 'Normal', 'nevo' ),
						'hover'  => __( 'Focus', 'nevo' ),
					),
				),
			),
			
			array(
				'name'       => 'content_heading_title',
				'type'       => 'styling',
				'section'    => 'global_style',
				'title'      => __( 'Heading Title', 'nevo' ),
				'description' => __( 'Used for global titles like Modules, Section,</br> Related Posts, Comments.', 'nevo' ),
				'selector'   => array(
					'normal' => '.site-main .heading-title',
					'normal_text_color' => '.site-main .general-title',
					'normal_padding' => '.site-main .general-title',
					'normal_margin' => '.site-main .heading-title, .widget .heading-title',
					'normal_bg_color' => '.site-main .general-title',
					'normal_border_radius' => '.site-main .general-title',
				),
				'default'   => array(
					'normal' => array(
					),
				),
				'css_format' => 'styling',
				'fields'     => array(
					'normal_fields' => array(
						'primary'	=> false,
						'secondary' => false,
						'success'	=> false,
						'info'	=> false,
						'warning'	=> false,
						'type_heading'	=> false,
						'link'	=> false,
						'link_hover'	=> false,
						'base'	=> false,
						'title'	=> false,
						'meta'	=> false,
						'heading'	=> false,
						'paddinga'    => false,
						'link_color'  => false,
						'box_shadow'  => false,
					),
					'hover_fields'  => false,
				),
			),
		);

		return array_merge( $configs, $config );
	}
}
add_filter( 'nevo/customizer/config', 'nevo_customizer_styling_config', 299 );