<?php
/**
 * The template part for displaying a message that posts cannot be found.
 *
 * @package Nevo
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

add_action( 'nevo_no_entry_content', 'nevo_do_no_entry_content' );
/**
 * Build the entry content.
 *
 * @since 1.0.0
 */
function nevo_do_no_entry_content() {
	?>
	<div class="no-results not-found">
		<div class="inside-article">
			<?php
			/**
			 * nevo_before_content hook.
			 *
			 * @since 1.0
			 */
			do_action( 'nevo_before_content' );
			
			/**
			 * nevo_before_entry_header hook.
			 *
			 * @since 1.0
			 */
			do_action( 'nevo_before_entry_header' );
			?>

			<header <?php nevo_do_attr( 'entry_header' ); ?>>
				<h1 class="entry-title"><?php echo apply_filters( 'nevo_no_content_page_title_text', __( 'Nothing Found', 'nevo' ) ); ?></h1>
			</header>

			<?php
			/**
			 * nevo_after_entry_header hook.
			 *
			 * @since 0.1
			 *
			 * @hooked nevo_post_image - 10
			 */
			do_action( 'nevo_after_entry_header' );
			?>

			<div class="entry-content">

					<?php if ( is_home() && current_user_can( 'publish_posts' ) ) : ?>

						<p><?php echo apply_filters( 'nevo_no_content_publishable_page_content_text', __( 'Ready to publish your first post? ', 'nevo' ) . '<a href="' . esc_url( admin_url( 'post-new.php' ) ) . '">' . __( 'Get started here', 'nevo' ) . '</a>.' ); ?></p>

					<?php elseif ( is_search() ) : ?>

						<p><?php echo apply_filters( 'nevo_no_content_search_page_content_text', __( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'nevo' ) ); ?></p>
						<?php get_search_form(); ?>

					<?php else : ?>

						<p><?php echo apply_filters( 'nevo_no_content_page_content_text', __( 'It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'nevo' ) ); ?></p>
						<?php get_search_form(); ?>

					<?php endif; ?>

			</div>

			<?php
			/**
			 * nevo_after_content hook.
			 *
			 * @since 0.1
			 */
			do_action( 'nevo_after_content' );
			?>
		</div>
	</div>
	<?php
}