<?php
/**
 * Build the sidebars.
 *
 * @package Nevo
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'nevo_construct_sidebars' ) ) {
	/**
	 * Construct the sidebars.
	 *
	 * @since 0.1
	 */
	function nevo_construct_sidebars() {
		$default = Nevo()->get_setting( 'sidebar_layout' );
		$layout = nevo_get_page_setting('sidebar_layout');
		
		if ( 'default' === $layout ) {
			$layout = $default;
		}
		// When to show the right sidebar.
		$rs = array( 'right-sidebar', 'both-sidebars', 'both-right', 'both-left' );

		// When to show the left sidebar.
		$ls = array( 'left-sidebar', 'both-sidebars', 'both-right', 'both-left' );

		// If left sidebar, show it.
		if ( in_array( $layout, $ls ) ) {
			get_sidebar( 'left' );
		}

		// If right sidebar, show it.
		if ( in_array( $layout, $rs ) ) {
			get_sidebar();
		}
	}

}

/**
 * Show sidebar widgets if no widgets are added to the sidebar area.
 *
 * @since 1.0
 *
 * @param string $area Left or right sidebar.
 */
function nevo_default_sidebar_widgets( $area ) {
	
	if ( ! apply_filters( 'nevo_show_default_sidebar_widgets', true ) ) {
		return;
	}
	$before_title  = apply_filters( 'nevo_start_widget_title', '<div class="heading-title"><h2 class="widget-title general-title">' );
	$after_title   = apply_filters( 'nevo_end_widget_title', '</h2></div>' );
	?>
	<aside id="search" class="widget widget_search">
		<?php get_search_form(); ?>
	</aside>

	<aside id="archives" class="widget">
		<?php
		echo $before_title;
		esc_html_e( 'Archives', 'nevo' );
		echo $after_title;
		?>
		<ul>
			<?php wp_get_archives( array( 'type' => 'monthly' ) ); ?>
		</ul>
	</aside>
	<?php
}
