<?php
/**
 * Advertisement Image widget.
 *
 * @package Nevo
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Advertisement Image widget.
 *
 * Class Nevo_Advertisement_Image
 */
class Nevo_Advertisement_Image extends Nevo_Widget {

	/**
	 * Constructor.
	 */
	public function __construct() {

		$this->widget_cssclass    = 'widget_qc_image';
		$this->widget_description = esc_html__( 'Add your Advertisement here', 'nevo' );
		$this->widget_name        = esc_html__( '*Νevo* Advertisement Image', 'nevo' );
		$this->settings           = array(
			'title'                => array(
				'type'    => 'text',
				'default' => '',
				'label'   => esc_html__( 'Title:', 'nevo' ),
			),
			'image_link'    => array(
				'type'    => 'url',
				'default' => '',
				'label'   => esc_html__( 'Advertisement Image Link', 'nevo' ),
			),
			'image_url'     => array(
				'type'    => 'image',
				'default' => '',
				'label'   => esc_html__( 'Advertisement Image', 'nevo' ),
			),
		);

		parent::__construct();

	}

	/**
	 * Output widget.
	 *
	 * @see WP_Widget
	 *
	 * @param array $args     Arguments.
	 * @param array $instance Widget instance.
	 */
	public function widget( $args, $instance ) {

		$title      = apply_filters( 'widget_title', isset( $instance['title'] ) ? $instance['title'] : '' );
		$image_link = isset( $instance['image_link'] ) ? $instance['image_link'] : '';
		$image_url  = isset( $instance['image_url'] ) ? $instance['image_url'] : '';

		$this->widget_start( $args );
		
		// Displays the widget title.
		if ( ! empty( $title ) ) {
			echo ! empty( $title ) ? $args['before_title'] . $title . $args['after_title'] : '';
		}
		$output = '';

		if ( ! empty( $image_url ) ) {
			$image_id  = attachment_url_to_postid( $image_url );
			$image_alt = get_post_meta( $image_id, '_wp_attachment_image_alt', true );

			$output .= '<div class="qc-content">';
			if ( ! empty( $image_link ) ) {
				$output .= '<a href="' . $image_link . '" class="single_ad_image" target="_blank" rel="nofollow">';
				$output .= '<img src="' . $image_url . '" width="728" height="90" alt="' . $image_alt . '">';
				$output .= '</a>';
			} else {
				$output .= '<img src="' . $image_url . '" width="728" height="90" alt="' . $image_alt . '">';
			}
			$output .= '</div>';

			echo $output; // phpcs:ignore WordPress.XSS.EscapeOutput.OutputNotEscaped
		}
		
		$this->widget_end( $args );
	}
}