<?php
/**
 * Recent Comments widget.
 *
 * @package Nevo
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Recent Comments widget.
 *
 * Class nevo_recent_comments_widget
 */
class nevo_recent_comments_widget extends Nevo_Widget {

	/**
	 * Constructor.
	 */
	public function __construct() {

		$this->widget_cssclass    = 'widget_recent_comments';
		$this->widget_name        = esc_html__( '*Νevo* Recent Comments', 'nevo' );
		$this->widget_description = esc_html__( 'Display Recent Comments.', 'nevo' );
		
		$this->settings   = array(
			'title'       => array(
				'type'    => 'text',
				'default' => 'Recent Comments',
				'label'   => esc_html__( 'Title:', 'nevo' ),
			),
			'post_type'   => array(
				'type'    => 'text',
				'col'     => 'col-1',
				'default' => 'post',
				'label'   => esc_html__( 'Post Type:', 'nevo' ),
			),
			'number'      => array(
				'type'    => 'number',
				'col'     => 'col-2',
				'default' => 5,
				'label'   => esc_html__( 'Number Comments:', 'nevo' ),
			),
			'offset'      => array(
				'type'    => 'number',
				'col'     => 'col-1',
				'default' => '',
				'label'   => esc_html__( 'Offset:', 'nevo' ),
			),
			'order'       => array(
				'type'    => 'select',
				'col'     => 'col-2',
				'default' => '',
				'label'   => esc_html__( 'Sort Order:', 'nevo' ),
				'choices' => array(
					'DESC' => esc_html__( 'Descending (DESC)', 'nevo' ),
					'ASC'  => esc_html__( 'Ascending (ASC)', 'nevo' ),
				),
			),
			'avatar'      => array(
				'type'    => 'checkbox',
				'col'     => 'col-1',
				'default' => 1,
				'label'   => esc_html__( 'Show avatar:', 'nevo' ),
			),
			'avatar_type'      => array(
				'type'    => 'checkbox',
				'col'     => 'col-2',
				'default' => 1,
				'label'   => esc_html__( 'Avatar rounded:', 'nevo' ),
			),
			'avatar_size' => array(
				'type'    => 'number',
				'col'     => 'col-1',
				'default' => 25,
				'label'   => esc_html__( 'Avatar Size:', 'nevo' ),
			),
			'avatar_position' => array(
				'type'    => 'select',
				'col'     => 'col-2',
				'default' => 'alignleft',
				'label'   => esc_html__( 'Avatar Position', 'nevo' ),
				'choices' => array(
					'alignleft'   => __( 'Left', 'nevo' ),
					'aligncenter' => __( 'Center', 'nevo' ),
					'alignright'  => __( 'Right', 'nevo' ),
				),
			),
			'time'      => array(
				'type'    => 'checkbox',
				'col'     => 'col-1',
				'default' => 1,
				'label'   => esc_html__( 'Show Date:', 'nevo' ),
			),
			'excerpt' => array(
				'type'    => 'checkbox',
				'col'     => 'col-2',
				'default' => 0,
				'label'   => esc_html__( 'Show Excerpt:', 'nevo' ),
			),
			'excerpt_length' => array(
				'type'    => 'number',
				'default' => 50,
				'label'   => esc_html__( 'Excerpt Length:', 'nevo' ),
			),
		);

		parent::__construct();

	}

	/**
	 * Output widget.
	 *
	 * @param array $args     Arguments.
	 * @param array $instance Widget instance.
	 *
	 * @see WP_Widget
	 */
	public function widget( $args, $instance ) {

		global $post;
		$title    	= apply_filters( 'widget_title', isset( $instance['title'] ) ? $instance['title'] : '' );
		$post_type 	= isset( $instance['post_type'] ) ? $instance['post_type'] : 'post';
		$number   	= empty( $instance['number'] ) ? 5 : $instance['number'];
		$offset   	= isset( $instance['offset'] ) ? $instance['offset'] : '';
		$order   	= isset( $instance['order'] ) ? $instance['order'] : '';
		$avatar   	= isset( $instance['avatar'] ) ? $instance['avatar'] : 1;
		$avatar_type = isset( $instance['avatar_type'] ) ? $instance['avatar_type'] : '';
		$avatar_size = empty( $instance['avatar_size'] ) ? 25 : $instance['avatar_size'];
		$avatar_position = isset( $instance['avatar_position'] ) ? $instance['avatar_position'] : 'alignleft';
		$time   	= isset( $instance['time'] ) ? $instance['time'] : 1;
		$excerpt 	= isset( $instance['excerpt'] ) ? $instance['excerpt'] : '';
		$excerpt_length = empty( $instance['excerpt_length'] ) ? 50 : $instance['excerpt_length'];

		if ( $avatar_type ) {
			$avatar_type = 'rounded-circle';
		}
		if ( $avatar_position === 'alignleft' ) {
			$avatar_position = 'cv-me-3 '. $avatar_position;
		}
		elseif ( $avatar_position === 'alignright' ) {
			$avatar_position = 'cv-ms-3 '. $avatar_position;
		} else {
			$avatar_position = 'cv-mb-3 '. $avatar_position;
		}
		
		$this->widget_start( $args );
		
		// Displays the widget title.
		if ( ! empty( $title ) ) {
			echo ! empty( $title ) ? $args['before_title'] . $title . $args['after_title'] : '';
		}
		
		$optlargs = array(
			'post_type'     => $post_type,
			'limit'         => $number,
			'offset'        => $offset,
			'order'         => $order,
			'exclude_pings' => 0,
			'avatar'        => $avatar,
			'avatar_size'   => $avatar_size,
			'avatar_type'   => $avatar_type,
			'avatar_align'  => $avatar_position,
			'time'          => $time,
			'excerpt'       => $excerpt,
			'excerpt_limit' => $excerpt_length,
			'status'        => 'approve',
			'post_status'   => 'publish',
		 ); 
		 echo nevo_display_comments_shortcode($optlargs);

		$this->widget_end( $args );

	}

}
