<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'nevo_customizer_product_archive_config' ) ) {
	function nevo_customizer_product_archive_config($configs = array()) {
		$section  = 'product_archive';
		$name     = 'product_archive';
		$selector = '.product-content';
		$config   = array(
			array(
				'name'  => $section,
				'type'  => 'section',
				'panel' => 'woocommerce',
				'priority' => 300,
				'title' => __( 'Product Archive', 'nevo' ),
			),
			
			array(
				'name'    => $section . '_h_page_header',
				'type'    => 'heading',
				'section' => $section,
				'priority' => 5,
				'title'   => __( 'Content Header', 'nevo' ),
			),
			
			array(
				'name'            => $section . '_page_header_layout',
				'type'            => 'radio_group',
				'section'         => $section,
				'title'           => __( 'Page Header Layout', 'nevo' ),
				'selector'        => '.archive.woocommerce .page-header .nevo-container',
				'css_format'      => 'html_class',
				'default'         => 'normal',
				'choices'         => array(
					'normal'      => __( 'Contained', 'nevo' ),
					'cv-mw-100'   => __( 'Full Width', 'nevo' ),
				),
				'priority' 		  => 8,
			),
			
			array(
				'name'            => $section . '_page_header_display',
				'type'            => 'select',
				'section'         => $section,
				'priority' 		  => 10,
				'device_settings' => false,
				'selector'        => '.archive.woocommerce .page-header',
				'default'         => 'after',
				'label'           => __( 'Display', 'nevo' ),
				'choices'         => array(
					'disable' 	=> __( 'Disable', 'nevo' ),
					'before' 	=> __( 'Before Content', 'nevo' ),
					'after' 	=> __( 'After Header', 'nevo' ),
				),
			),
			
			array(
				'name'            => $section . 'one_containers_padding',
				'type'            => 'css_ruler',
				'section'         => $section,
				'priority' 		  => 12,
				'title'           => __( 'Padding', 'nevo' ),
				'device_settings' => true,
				'css_format'      => array(
					'top'    => 'padding-top: {{value}};',
					'right'  => 'padding-right: {{value}};',
					'bottom' => 'padding-bottom: {{value}};',
					'left'   => 'padding-left: {{value}};',
				),
				'selector'        => '.archive.woocommerce .one-container .site-main .inside-page-header',
				'required'   => array(
					array( 'content_layout', '=', 'one-container' ),
					array( $section . '_page_header_display', '=', 'before' )
				),
			),
						
			array(
				'name'             => $section . '_page_header_elements',
				'type'             => 'repeater',
				'section'          => $section,
				'priority' 		  => 15,
				'selector'         => '.archive.woocommerce .page-header',
				'title'            => __( 'Elements', 'nevo' ),
				'description'      => __( 'Drag and drop to reorder.', 'nevo' ),
				'live_title_field' => 'title',
				'addable'          => false,
				'title_only'       => true,
				'default'          => apply_filters(
					'nevo_page_header_archive_elements', array(
						array(
							'title' 	=> 'Breadcrumb',
							'elements'  => 'breadcrumb',
						),
						array(
							'title' 	=> 'Archive Title',
							'elements'  => 'title',
						),
						array(
							'title' 	=> 'Description',
							'elements'  => 'description',
						)
					),
				),
				'fields'           => array(
					array(
						'name'  => 'title',
						'type'  => 'hidden',
						'label' => __( 'Title', 'nevo' ),
					),
					array(
						'name' => 'elements',
						'type' => 'hidden',
					),
					
				),
			),
			
			array(
				'name'            => $section . '_page_header_background_image',
				'type'            => 'select',
				'section'         => $section,
				'priority' 		  => 20,
				'device_settings' => false,
				'selector'        => '.archive.woocommerce .page-header',
				'default'         => 'global',
				'label'           => __( 'Background image', 'nevo' ),
				'render_callback' => 'nevo_page_header_section',
				'choices'         => array(
					'global' 	=> __( 'Global', 'nevo' ),
					'custom' 	=> __( 'Custom', 'nevo' ),
					'thumbnail' => __( 'Featured image', 'nevo' ),
				),
			),
			
			array(
				'name'            => $section . 'one_containers_padding',
				'type'            => 'css_ruler',
				'section'         => $section,
				'title'           => __( 'Padding', 'nevo' ),
				'device_settings' => true,
				'css_format'      => array(
					'top'    => 'padding-top: {{value}};',
					'right'  => 'padding-right: {{value}};',
					'bottom' => 'padding-bottom: {{value}};',
					'left'   => 'padding-left: {{value}};',
				),
				'selector'        => '.one-container .site-main .inside-page-header',
				'required'   => array(
					array( 'content_layout', '=', 'one-container' ),
					array( 'post_archive_page_header_display', '=', 'before' )
				),
			),
			
			array(
				'name'       => $section . '_page_header_style',
				'type'       => 'modal',
				'priority'   => 25,
				'section'    => $section,
				'title'      => __( 'Page Header Styling', 'nevo' ),
				'selector'   => '.archive.woocommerce .page-header',
				'css_format' => 'styling',
				'fields'     => array(
					'tabs'          => array(
						'normal' => __( 'Normal', 'nevo' ),
					),
					'normal_fields' => array(
						array(
							'name'       => $section . '_text_color',
							'type'       => 'color',
							'label'      => __( 'Color', 'nevo' ),
							'default'    => '#ffffff',
							'selector'   => '.archive.woocommerce .page-header .inside-page-header, .archive.woocommerce .page-header .page-title',
							'css_format' => 'color: {{value}}; text-decoration-color: {{value}};',
						),
						array(
							'name'       => $section . '_link_color',
							'type'       => 'color',
							'label'      => __( 'Link Color', 'nevo' ),
							'default'    => '#ffffff',
							'selector'   => '.archive.woocommerce .page-header .inside-page-header a',
							'css_format' => 'color: {{value}}; text-decoration-color: {{value}};',
						),
						array(
							'name'       => $section . '_hover_link_color',
							'type'       => 'color',
							'label'      => __( 'Link Color Hover', 'nevo' ),
							'default'    => '#ffffff',
							'selector'   => '.archive.woocommerce .page-header .inside-page-header a:hover, .archive.woocommerce .page-header .inside-page-header a:focus',
							'css_format' => 'color: {{value}}; text-decoration-color: {{value}};',
						),
						
						array(
							'name'            => $section . '_page_header_align',
							'type'            => 'text_align_no_justify',
							'device_settings' => true,
							'selector'   	  => ".archive.woocommerce .page-header .inside-page-header",
							'css_format'      => 'text-align: {{value}};',
							'label'           => __( 'Align', 'nevo' ),
						),
						array(
							'name'  => $section . '_bg_heading',
							'type'  => 'heading',
							'label' => __( 'Background', 'nevo' ),
						),
						
						array(
							'name'       => $section . '_bg_color',
							'type'       => 'color',
							'label'      => __( 'Background Color', 'nevo' ),
							'selector'   => '.archive.woocommerce .page-header',
							'css_format' => 'background-color: {{value}};',
						),
						array(
							'name'       => $section . '_bg_overlay_color',
							'type'       => 'color',
							'label'      => __( 'Background overlay color', 'nevo' ),
							'selector'   => '.archive.woocommerce .page-header:before',
							'css_format' => 'background-color: {{value}};',
						),
						array(
							'name'       => $section . '_bg_image',
							'type'       => 'image',
							'label'      => __( 'Background Image', 'nevo' ),
							'selector'   => '.archive.woocommerce .page-header',
							'css_format' => 'background-image: url("{{value}}");',
							'device_settings' => false,
						),
						array(
							'name'       => $section . '_bg_cover',
							'type'       => 'select',
							'default'    => 'cover',
							'choices'    => array(
								''        => __( 'Default', 'nevo' ),
								'auto'    => __( 'Auto', 'nevo' ),
								'cover'   => __( 'Cover', 'nevo' ),
								'contain' => __( 'Contain', 'nevo' ),
							),
							'label'      => __( 'Size', 'nevo' ),
							'class'      => 'field-half-left',
							'selector'   => '.archive.woocommerce .page-header',
							'css_format' => '-webkit-background-size: {{value}}; -moz-background-size: {{value}}; -o-background-size: {{value}}; background-size: {{value}};',
							'required'   => array( $section . '_bg_image', 'not_empty', '' ),
						),
						array(
							'name'       => $section . '_bg_position',
							'type'       => 'select',
							'label'      => __( 'Position', 'nevo' ),
							'class'      => 'field-half-right',
							'default'    => 'center',
							'choices'    => array(
								''              => __( 'Default', 'nevo' ),
								'center'        => __( 'Center', 'nevo' ),
								'top left'      => __( 'Top Left', 'nevo' ),
								'top right'     => __( 'Top Right', 'nevo' ),
								'top center'    => __( 'Top Center', 'nevo' ),
								'bottom left'   => __( 'Bottom Left', 'nevo' ),
								'bottom center' => __( 'Bottom Center', 'nevo' ),
								'bottom right'  => __( 'Bottom Right', 'nevo' ),
							),
							'selector'   => '.archive.woocommerce .page-header',
							'css_format' => 'background-position: {{value}};',
							'required'   => array( $section . '_bg_image', 'not_empty', '' ),
						),
						array(
							'name'       => $section . '_bg_repeat',
							'type'       => 'select',
							'label'      => __( 'Repeat', 'nevo' ),
							'class'      => 'field-half-left',
							'default'    => 'no-repeat',
							'choices'    => array(
								'repeat'    => __( 'Default', 'nevo' ),
								'no-repeat' => __( 'No repeat', 'nevo' ),
								'repeat-x'  => __( 'Repeat horizontal', 'nevo' ),
								'repeat-y'  => __( 'Repeat vertical', 'nevo' ),
							),
							'selector'   => '.archive.woocommerce .page-header',
							'css_format' => 'background-repeat: {{value}};',
							'required'   => array( $section . '_bg_image', 'not_empty', '' ),
						),

						array(
							'name'       => $section . '_bg_attachment',
							'type'       => 'select',
							'label'      => __( 'Attachment', 'nevo' ),
							'class'      => 'field-half-right',
							'choices'    => array(
								''       => __( 'Default', 'nevo' ),
								'scroll' => __( 'Scroll', 'nevo' ),
								'fixed'  => __( 'Fixed', 'nevo' ),
							),
							'selector'   => '.archive.woocommerce .page-header',
							'css_format' => 'background-attachment: {{value}};',
							'required'   => array( $section . '_bg_image', 'not_empty', '' ),
						),
					),
				),
			),
			
			array(
				'name'        => $section . '_page_header_typography',
				'type'        => 'typography',
				'section'     => $section,
				'priority' 	  => 35,
				'title'       => __( 'Archive  Title Typography', 'nevo' ),
				'css_format'  => 'typography',
				'selector'    => ".archive.woocommerce .page-header .page-title",
				'fields'      => array(
					'font'      		=> false,
					'font_weight'    	=> false,
					'style' 			=> false,
					'text_decoration' 	=> false,
					'text_transform' 	=> false,
					'languages' 		=> false,
					'line_height'    	=> false,
					'letter_spacing' 	=> false,
				),
			),
			
			array(
				'name'    => $name . '_h_content',
				'type'    => 'heading',
				'section' => $section,
				'priority' => 45,
				'title'   => __( 'Content / Sidebar', 'nevo' ),
			),
			
			array(
				'name'    => $name . '_sidebar_layout',
				'type'    => 'image_select',
				'priority' => 50,
				'default' => 'right-sidebar',
				'section' => $section,
				'title'   => __( 'Sidebar Layout', 'nevo' ),
				'choices' => nevo_get_sidebar_layouts(),
			),
			
			array(
				'name'            => $name . '_result_count',
				'type'            => 'checkbox',
				'default'   	  => 1,
				'section'         => $section,
				'priority' 		  => 55,
				'checkbox_label'  => __( 'Show Result Count', 'nevo' ),
				'selector'        => $selector,
			),
			
			array(
				'name'            => $name . '_filtering',
				'type'            => 'checkbox',
				'default'   	  => 1,
				'section'         => $section,
				'priority' 		  => 60,
				'checkbox_label'  => __( 'Show Product Filtering', 'nevo' ),
				'selector'        => $selector,
			),
			
			array(
				'name'            => $name . '_product_number',
				'type'            => 'text',
				'section'         => $section,
				'priority' 		  => 65,
				'selector'        => $selector,
				'default'         => 9,
				'label'           => __( 'Number Product to show', 'nevo' ),
			),
			
			array(
				'name'            => $name . '_product_col',
				'type'            => 'select',
				'section'         => $section,
				'priority' 		  => 70,
				'default'         => array(
					'desktop' => 3,
					'tablet'  => 2,
					'mobile'  => 2,
				),
				'max'             => 12,
				'device_settings' => true,
				'selector'        => $selector,
				'label'           => __( 'Number columns to show', 'nevo' ),
				'choices'         => array(
					1 => 1,
					2 => 2,
					3 => 3,
					4 => 4,
					5 => 5,
					6 => 6,
				),
			),
			
			array(
				'name'            => $name . '_product_content_align',
				'type'            => 'text_align_no_justify',
				'section'         => $section,
				'priority' 		  => 80,
				'device_settings' => true,
				'selector'   	  => ".product .col-inner, .product-content-wrap, .woocommerce-product-rating",
				'css_format'      => 'text-align: {{value}}; justify-content: {{value}};',
				'title'           => __( 'Align', 'nevo' ),
			),
			
			array(
				'name'            => $name . '_items_category',
				'type'            => 'checkbox',
				'default'   	  => 0,
				'section'         => $section,
				'priority' 		  => 85,
				'checkbox_label'  => __( 'Product Category', 'nevo' ),
				'selector'        => $selector,
			),
			
			array(
				'name'            => $name . '_items_title',
				'type'            => 'checkbox',
				'default'   	  => 1,
				'section'         => $section,
				'priority' 		  => 100,
				'checkbox_label'  => __( 'Product Title', 'nevo' ),
				'selector'        => $selector,
			),
			
			array(
				'name'            => $name . '_items_price',
				'type'            => 'checkbox',
				'default'   	  => 1,
				'section'         => $section,
				'priority' 		  => 105,
				'checkbox_label'  => __( 'Product Price', 'nevo' ),
				'selector'        => $selector,
			),
			
			array(
				'name'            => $name . '_items_description',
				'type'            => 'checkbox',
				'default'   	  => 0,
				'section'         => $section,
				'priority' 		  => 110,
				'label'  => __( 'Product Description', 'nevo' ),
				'selector'        => $selector,
			),
			
			array(
				'name'            => $name . '_items_rating',
				'type'            => 'checkbox',
				'default'   	  => 0,
				'section'         => $section,
				'priority' 		  => 115,
				'checkbox_label'  => __( 'Product Rating', 'nevo' ),
				'selector'        => $selector,
			),
			
			array(
				'name'            => $name . '_items_quantity',
				'type'            => 'checkbox',
				'default'   	  => 0,
				'section'         => $section,
				'priority' 		  => 120,
				'checkbox_label'  => __( 'Product Quantity', 'nevo' ),
				'selector'        => $selector,
			),
			
			array(
				'name'            => $section . 'title_height',
				'type'            => 'slider',
				'device_settings' => false,
				'min'             => 1,
				'step'            => 1,
				'max'             => 2,
				'default'   	  => 1,
				'unit'            => 'lin',
				'section'         => $section,
				'priority' 		  => 125,
				'selector'        => '.product-content-wrap .woocommerce-loop-product__title',
				'css_format'      => 'height: {{value_no_unit}}.4em;-webkit-line-clamp: {{value_no_unit}};display: -webkit-box;overflow: hidden;-webkit-box-orient: vertical;text-overflow: ellipsis;',
				'label'           => __( 'Product Limit Title', 'nevo' ),
				'description'     => __( 'Limited by line.', 'nevo' ),
			),
			
			array(
				'name'            => $section . 'content_height',
				'type'            => 'slider',
				'device_settings' => false,
				'section'         => $section,
				'priority' 		  => 130,
				'selector'        => '.product-content-wrap',
				'css_format'      => 'min-height: {{value}};',
				'label'           => __( 'Product Content Min Height', 'nevo' ),
				'description'     => __( 'Equal Product Content.', 'nevo' ),
			),
			
			array(
				'name'       => $name . '_text_color',
				'type'       => 'styling',
				'section'    => $section,
				'priority' 	 => 135,
				'title'      => __( 'Text Color', 'nevo' ),
				'selector'   => array(
					'normal' => 'ul.products li.product .woocommerce-loop-product__title a, .product-content-wrap .woocommerce-loop-category__title, .product-content-wrap .woocommerce-loop-product__title, .product-content-wrap .price, .product-content-wrap .product-description',
					'hover'  => 'ul.products li.product .woocommerce-loop-product__title a:hover, .product-content-wrap .woocommerce-loop-category__title:hover',
				),
				'default'   => array(
					'normal' => array(
					),
					'hover' => array(
					),
				),
				'css_format' => 'styling',
				'fields'     => array(
					'normal_fields' => array(
						'primary'	=> false,
						'secondary' => false,
						'success'	=> false,
						'info'	=> false,
						'warning'	=> false,
						'type_heading'	=> false,
						'link'	=> false,
						'link_hover'	=> false,
						'base'	=> false,
						'title'	=> false,
						'meta'	=> false,
						'heading'	=> false,
						'bg_heading' 	 => false,
						'bg_color' 		 => false,
						'bg_image' 		 => false,
						'padding'        => false,
						'paddinga'    	 => false,
						'margin'         => false,
						'border_heading' => false,
						'border_width'   => false,
						'border_color'   => false,
						'border_radius'  => false,
						'box_shadow'     => false,
						'border_style'   => false,
					),
					'hover_fields'  => array(
						'bg_heading' 	 => false,
						'bg_color' 		 => false,
						'bg_image' 		 => false,
						'text_color'     => false,
						'padding'        => false,
						'margin'         => false,
						'border_heading' => false,
						'border_width'   => false,
						'border_color'   => false,
						'border_radius'  => false,
						'box_shadow'     => false,
						'border_style'   => false,
					),
				),
			),
			
			array(
				'name'       => $name . '_styling',
				'type'       => 'styling',
				'section'    => $section,
				'priority' 	 => 140,
				'title'      => __( 'Product Styling', 'nevo' ),
				'selector'   => array(
					'normal' => 'ul.products li.product .col-inner',
				),
				'default'   => array(
					'normal' => array(
						'bg_color' => '#ffffff',
					),
				),
				'css_format' => 'styling', // styling.
				'fields'     => array(
					'normal_fields' => array(
						'primary'	=> false,
						'secondary' => false,
						'success'	=> false,
						'info'	=> false,
						'warning'	=> false,
						'type_heading'	=> false,
						'link'	=> false,
						'link_hover'	=> false,
						'base'	=> false,
						'title'	=> false,
						'meta'	=> false,
						'heading'	=> false,
						'text_color' 	 => false,
						'link_color'     => false,
						'paddinga'    	 => false,
						'bg_image' 		 => false,
					),
					'hover_fields'  => false,
				),
			),
			
			array(
				'name'    => $name . '_h_product_images',
				'type'    => 'heading',
				'section' => $section,
				'priority' => 145,
				'title'   => __( 'Product Images', 'nevo' ),
			),
			
			array(
				'name'            => $name . '_equalimg_height',
				'type'            => 'checkbox',
				'default'   	  => 0,
				'section'         => $section,
				'priority' 		  => 150,
				'checkbox_label'  => __( 'Equal Image Height', 'nevo' ),
				'selector'        => $selector,
			),
			
			array(
				'name'            => $name . 'img_height',
				'type'            => 'slider',
				'device_settings' => false,
				'theme_supports'  => '',
				'default'         => 300,
				'min'             => 100,
				'step'            => 1,
				'max'             => 600,
				'section'         => $section,
				'priority' 		  => 155,
				'label'           => __( 'Image Height', 'nevo' ),
				'description'     => __( 'Equal Image Height.', 'nevo' ),
				'selector'        => 'ul.products li.product .product-image-wrap.equal-height',
				'css_format'      => 'height: {{value}};',
				'required'        => array( $name . '_equalimg_height', '=', '1' ),
			),
			
			array(
				'name'            => $name . '_img_hover',
				'type'            => 'select',
				'section'         => $section,
				'priority' 		  => 160,
				'default'         => 'zoom',
				'choices'         => array(
					'none'  => __( 'None', 'nevo' ),
					'zoom'  => __( 'Zoom', 'nevo' ),
					'swap'  => __( 'Swap', 'nevo' ),
				),
				'selector'        => $selector,
				'label'           => __( 'Images Hover Effect', 'nevo' ),
			),
			
			array(
				'name'    => $name . '_h_sale',
				'type'    => 'heading',
				'section' => $section,
				'priority' => 165,
				'title'   => __( 'Featured & Sale Tag', 'nevo' ),
			),
			
			array(
				'name'            => $name . '_sale_percentage',
				'type'            => 'checkbox',
				'default'   	  => 1,
				'section'         => $section,
				'priority' 		  => 170,
				'checkbox_label'  => __( 'Sale Percentage', 'nevo' ),
				'selector'        => $selector,
			),
			
			array(
				'name'            => $name . '_sale_text',
				'type'            => 'text',
				'section'         => $section,
				'priority' 		  => 175,
				'selector'        => $selector,
				'default'         => __( 'Sale!', 'nevo' ),
				'label'           => __( 'Sale Text', 'nevo' ),
				'required'        => array( $name . '_sale_percentage', '!=', '1' ),
			),
			
			array(
				'name'       => $name . '_sale_styling',
				'type'       => 'styling',
				'section'    => $section,
				'priority' 	 => 180,
				'title'      => __( 'Sale Styling', 'nevo' ),
				'selector'   => array(
					'normal' => 'ul.products li.product .on-sale',
				),
				'default'   => array(
					'normal' => array(
						'text_color' => '#ffffff',
					),
				),
				'css_format' => 'styling',
				'fields'     => array(
					'normal_fields' => array(
						'primary'	=> false,
						'secondary' => false,
						'success'	=> false,
						'info'	=> false,
						'warning'	=> false,
						'type_heading'	=> false,
						'link'	=> false,
						'link_hover'	=> false,
						'base'	=> false,
						'title'	=> false,
						'meta'	=> false,
						'heading'	=> false,
						'link_color'     => false,
						'bg_image' 		 => false,
						'margin'         => false,
						'paddinga'    	 => false,
						'border_heading' => false,
						'border_width'   => false,
						'border_color'   => false,
						'border_radius'  => false,
						'box_shadow'     => false,
						'border_style'   => false,
						'box_shadow'     => false,
					),
					'hover_fields'  => false,
				),
			),
			
			array(
				'name'            => $name . '_show_featured',
				'type'            => 'checkbox',
				'default'   	  => 1,
				'section'         => $section,
				'priority' 		  => 185,
				'checkbox_label'  => __( 'Product Featured Text', 'nevo' ),
				'selector'        => $selector,
			),
			
			array(
				'name'            => $name . '_featured_text',
				'type'            => 'text',
				'section'         => $section,
				'priority' 		  => 190,
				'selector'        => $selector,
				'default'         => __( 'Hot', 'nevo' ),
				'label'           => __( 'Featured Text', 'nevo' ),
				'required'        => array( $name . '_show_featured', '=', '1' ),
			),
			
			array(
				'name'       => $name . '_featured_styling',
				'type'       => 'styling',
				'section'    => $section,
				'priority' 	 => 195,
				'title'      => __( 'Featured Styling', 'nevo' ),
				'selector'   => array(
					'normal' => 'ul.products li.product .callout',
				),
				'default'   => array(
					'normal' => array(
						'text_color' => '#ffffff',
					),
				),
				'css_format' => 'styling',
				'fields'     => array(
					'normal_fields' => array(
						'primary'	=> false,
						'secondary' => false,
						'success'	=> false,
						'info'	=> false,
						'warning'	=> false,
						'type_heading'	=> false,
						'link'	=> false,
						'link_hover'	=> false,
						'base'	=> false,
						'title'	=> false,
						'meta'	=> false,
						'heading'	=> false,
						'link_color'     => false,
						'bg_image' 		 => false,
						'margin'         => false,
						'paddinga'    	 => false,
						'border_heading' => false,
						'border_width'   => false,
						'border_color'   => false,
						'border_radius'  => false,
						'box_shadow'     => false,
						'border_style'   => false,
						'box_shadow'     => false,
					),
					'hover_fields'  => false,
				),
			),
			
			array(
				'name'    => $name . '_h_stock',
				'type'    => 'heading',
				'section' => $section,
				'priority' => 200,
				'title'   => __( 'Out Of Stock', 'nevo' ),
			),
			
			array(
				'name'            => $name . '_stock_text',
				'type'            => 'text',
				'section'         => $section,
				'priority' 		  => 205,
				'selector'        => $selector,
				'default'         => __( 'Out Of Stock', 'nevo' ),
				'label'           => __( 'Text', 'nevo' ),
			),
		);

		return array_merge( $configs, $config );
	}
}
add_filter( 'nevo/customizer/config', 'nevo_customizer_product_archive_config', 200 );