<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'nevo_customizer_product_cart_config' ) ) {
	function nevo_customizer_product_cart_config($configs = array()) {
		$section  = 'product_cart';
		$name     = 'product_cart';
		$selector = '.product-content';
		$config   = array(
			array(
				'name'  => $section,
				'type'  => 'section',
				'panel' => 'woocommerce',
				'priority' => 300,
				'title' => __( 'Product Cart page', 'nevo' ),
			),
			
			array(
				'name'            => $name . '_cross_sell',
				'type'            => 'checkbox',
				'default'   	  => 1,
				'section'         => $section,
				'priority' 		  => 50,
				'checkbox_label'  => __( 'Show Cross-sell Product', 'nevo' ),
				'selector'        => $selector,
			),
			
			array(
				'name'            => $name . '_cross_sell_col',
				'type'            => 'select',
				'section'         => $section,
				'priority' 		  => 55,
				'default'         => 2,
				'device_settings' => false,
				'selector'        => $selector,
				'label'           => __( 'Cross-sell Columns', 'nevo' ),
				'choices'         => array(
					1 => 1,
					2 => 2,
					3 => 3,
					4 => 4,
					5 => 5,
					6 => 6,
				),
			),
			
		);

		return array_merge( $configs, $config );
	}
}
add_filter( 'nevo/customizer/config', 'nevo_customizer_product_cart_config', 399 );