<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'nevo_customizer_header_cart_config' ) ) {
	function nevo_customizer_header_cart_config($configs = array()) {
		$section  = 'header_cart';
		$name     = 'header_cart';
		$selector = '.header-min-cart';
		$config   = array(
			array(
				'name'  => $section,
				'type'  => 'section',
				'panel' => 'nevo_header',
				'priority' => 100,
				'title' => __( 'Cart', 'nevo' ),
			),
			
			array(
				'name'            => $name . '_text',
				'type'            => 'text',
				'section'         => $section,
				'selector'        => $selector,
				'render_callback' => 'nevo_refresh_header_cart_partials',
				'title'           => __( 'Label', 'nevo' ),
				'default'         => __( 'Cart /', 'nevo' ),
			),

			array(
				'name'            => $name . '_icon',
				'type'            => 'icon',
				'section'         => $section,
				'selector'        => $selector,
				'render_callback' => 'nevo_refresh_header_cart_partials',
				'theme_supports'  => '',
				'default'  		  => array(
					'type' => 'bootstrap-icons',
					'icon' => 'bi-bag',
				),
				'title'           => __( 'Icon', 'nevo' ),
			),
			
			array(
				'name'       	  => $name . '_size',
				'type'       	  => 'slider',
				'device_settings' => false,
				'section'    	  => $section,
				'min'             => 0,
				'step'            => 1,
				'max'             => 100,
				'default'         => 20,
				'label'      	  => __( 'Icon size', 'nevo' ),
				'selector'   	  => $selector,
				'render_callback' => 'nevo_refresh_header_cart_partials',
			),
			
			array(
				'name'            => $name . '_text_label',
				'type'            => 'checkbox',
				'section'         => $section,
				'selector'        => $selector,
				'default'         => 1,
				'render_callback' => 'nevo_refresh_header_cart_partials',
				'title'  		  => __( 'Show Label', 'nevo' ),
			),
			
			array(
				'name'            => $name . '_sub_total',
				'type'            => 'checkbox',
				'section'         => $section,
				'selector'        => $selector,
				'default'         => 1,
				'render_callback' => 'nevo_refresh_header_cart_partials',
				'title'  		  => __( 'Show Sub Total', 'nevo' ),
			),
			
			array(
				'name'       => $name . '_bg_count_color',
				'type'       => 'color',
				'device_settings' => true,
				'section'    => $section,
				'title'      => __( 'Background Cart Count', 'nevo' ),
				'selector'   => ".header-min-cart .cart-count",
				'css_format' => 'background-color: {{value}}',
			),
			
			array(
				'name'       => $name . '_setting',
				'type'       => 'modal',
				'section'    => $section,
				'selector'   => '.cart-toggle .cart-contents',
				'css_format' => 'styling',
				'title'       => __( 'Styling', 'nevo' ),
				'description' => __( 'Custom mini cart', 'nevo' ),
				'fields'     => array(
					'tabs'           => array(
						'default' => __( 'Normal', 'nevo' ),
						'hover'   => __( 'Hover', 'nevo' ),
					),
					'default_fields' => array(
						array(
							'name'       => $name . '_color',
							'type'       => 'color',
							'device_settings' => true,
							'label'      => __( 'Color', 'nevo' ),
							'selector'   => '.cart-toggle .cart-contents',
							'css_format' => 'color: {{value}}; text-decoration-color: {{value}};',
						),
						array(
							'name'       => $name . '_bg_color',
							'type'       => 'color',
							'device_settings' => true,
							'label'      => __( 'Background Color', 'nevo' ),
							'selector'   => '.cart-toggle .cart-contents',
							'css_format' => 'background-color: {{value}};',
						),
						
						array(
							'name'            => $name . '_padding',
							'type'            => 'css_ruler',
							'device_settings' => true,
							'selector'   	  => '.cart-toggle .cart-contents',
							'css_format'      => array(
								'top'    => 'padding-top: {{value}};',
								'right'  => 'padding-right: {{value}};',
								'bottom' => 'padding-bottom: {{value}};',
								'left'   => 'padding-left: {{value}};',
							),
							'label'           => __( 'Padding', 'nevo' ),
						),
						
						array(
							'name'  => $name . '_border_heading',
							'type'  => 'heading',
							'label' => __( 'Border', 'nevo' ),
						),

						array(
							'name'       => $name . '_border_style',
							'type'       => 'select',
							'class'      => 'clear',
							'selector'   => '.cart-toggle .cart-contents',
							'label'      => __( 'Border Style', 'nevo' ),
							'default'    => '',
							'choices'    => array(
								''       => __( 'Default', 'nevo' ),
								'none'   => __( 'None', 'nevo' ),
								'solid'  => __( 'Solid', 'nevo' ),
								'dotted' => __( 'Dotted', 'nevo' ),
								'dashed' => __( 'Dashed', 'nevo' ),
								'double' => __( 'Double', 'nevo' ),
								'ridge'  => __( 'Ridge', 'nevo' ),
								'inset'  => __( 'Inset', 'nevo' ),
								'outset' => __( 'Outset', 'nevo' ),
							),
							'css_format' => 'border-style: {{value}};',
						),

						array(
							'name'       => $name . '_border_width',
							'type'       => 'css_ruler',
							'label'      => __( 'Border Width', 'nevo' ),
							'selector'   => '.cart-toggle .cart-contents',
							'required'   => array(
								array( $name . '_border_style', '!=', 'none' ),
								array( $name . '_border_style', '!=', '' ),
							),
							'css_format' => array(
								'top'    => 'border-top-width: {{value}};',
								'right'  => 'border-right-width: {{value}};',
								'bottom' => 'border-bottom-width: {{value}};',
								'left'   => 'border-left-width: {{value}};',
							),
						),
						array(
							'name'       => $name . '_border_color',
							'type'       => 'color',
							'label'      => __( 'Border Color', 'nevo' ),
							'selector'   => '.cart-toggle .cart-contents',
							'required'   => array(
								array( $name . '_border_style', '!=', 'none' ),
								array( $name . '_border_style', '!=', '' ),
							),
							'css_format' => 'border-color: {{value}};',
						),

						array(
							'name'       => $name . '_border_radius',
							'type'       => 'css_ruler',
							'label'      => __( 'Border Radius', 'nevo' ),
							'selector'   => '.cart-toggle .cart-contents',
							'css_format' => array(
								'top'    => 'border-top-left-radius: {{value}};',
								'right'  => 'border-top-right-radius: {{value}};',
								'bottom' => 'border-bottom-right-radius: {{value}};',
								'left'   => 'border-bottom-left-radius: {{value}};',
							),
						),
					),
					'hover_fields'   => array(
						array(
							'name'       => $name . '_color',
							'type'       => 'color',
							'device_settings' => true,
							'label'      => __( 'Color', 'nevo' ),
							'selector'   => ".cart-toggle .cart-contents:hover",
							'css_format' => 'color: {{value}}; text-decoration-color: {{value}};',
						),
						array(
							'name'       => $name . '_bg_color',
							'type'       => 'color',
							'device_settings' => true,
							'label'      => __( 'Background Color', 'nevo' ),
							'selector'   => ".cart-toggle .cart-contents:hover",
							'css_format' => 'background-color: {{value}};',
						),
						
						array(
							'name'  => $name . '_border_heading',
							'type'  => 'heading',
							'label' => __( 'Border', 'nevo' ),
						),

						array(
							'name'       => $name . '_border_style',
							'type'       => 'select',
							'class'      => 'clear',
							'selector'   => '.cart-toggle .cart-contents:hover',
							'label'      => __( 'Border Style', 'nevo' ),
							'default'    => '',
							'choices'    => array(
								''       => __( 'Default', 'nevo' ),
								'none'   => __( 'None', 'nevo' ),
								'solid'  => __( 'Solid', 'nevo' ),
								'dotted' => __( 'Dotted', 'nevo' ),
								'dashed' => __( 'Dashed', 'nevo' ),
								'double' => __( 'Double', 'nevo' ),
								'ridge'  => __( 'Ridge', 'nevo' ),
								'inset'  => __( 'Inset', 'nevo' ),
								'outset' => __( 'Outset', 'nevo' ),
							),
							'css_format' => 'border-style: {{value}};',
						),

						array(
							'name'       => $name . '_border_width',
							'type'       => 'css_ruler',
							'label'      => __( 'Border Width', 'nevo' ),
							'selector'   => '.cart-toggle .cart-contents:hover',
							'required'   => array(
								array( $name . '_border_style', '!=', 'none' ),
								array( $name . '_border_style', '!=', '' ),
							),
							'css_format' => array(
								'top'    => 'border-top-width: {{value}};',
								'right'  => 'border-right-width: {{value}};',
								'bottom' => 'border-bottom-width: {{value}};',
								'left'   => 'border-left-width: {{value}};',
							),
						),
						array(
							'name'       => $name . '_border_color',
							'type'       => 'color',
							'label'      => __( 'Border Color', 'nevo' ),
							'selector'   => '.cart-toggle .cart-contents:hover',
							'required'   => array(
								array( $name . '_border_style', '!=', 'none' ),
								array( $name . '_border_style', '!=', '' ),
							),
							'css_format' => 'border-color: {{value}};',
						),

						array(
							'name'       => $name . '_border_radius',
							'type'       => 'css_ruler',
							'label'      => __( 'Border Radius', 'nevo' ),
							'selector'   => '.cart-toggle .cart-contents:hover',
							'css_format' => array(
								'top'    => 'border-top-left-radius: {{value}};',
								'right'  => 'border-top-right-radius: {{value}};',
								'bottom' => 'border-bottom-right-radius: {{value}};',
								'left'   => 'border-bottom-left-radius: {{value}};',
							),
						),
					),
				),
			),
		);
		return array_merge( $configs, $config );
	}
}
add_filter( 'nevo/customizer/config', 'nevo_customizer_header_cart_config', 99 );

function nevo_refresh_header_cart_partials() {
	nevo_header_element( 'cart');
}