<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'nevo_customizer_product_single_config' ) ) {
	function nevo_customizer_product_single_config($configs = array()) {
		$section  = 'product_single';
		$name     = 'product_single';
		$selector = '.product-content';
		$config   = array(
			
			array(
				'name'  => $section,
				'type'  => 'section',
				'panel' => 'woocommerce',
				'priority' => 310,
				'title' => __( 'Product Single', 'nevo' ),
			),
			
			array(
				'name'    => $section . '_h_page_header',
				'type'    => 'heading',
				'section' => $section,
				'title'   => __( 'Content Header', 'nevo' ),
			),
			
			array(
				'name'            => $section . '_page_header_layout',
				'type'            => 'radio_group',
				'section'         => $section,
				'title'           => __( 'Page Header Layout', 'nevo' ),
				'selector'        => 'body.single-product .page-header .nevo-container',
				'css_format'      => 'html_class',
				'default'         => 'normal',
				'choices'         => array(
					'normal'      => __( 'Contained', 'nevo' ),
					'cv-mw-100'   => __( 'Full Width', 'nevo' ),
				),
			),
			
			array(
				'name'            => $section . '_page_header_display',
				'type'            => 'select',
				'section'         => $section,
				'device_settings' => false,
				'selector'        => 'body.single-product .page-header',
				'default'         => 'after',
				'label'           => __( 'Display', 'nevo' ),
				'choices'         => array(
					'disable' 	=> __( 'Disable', 'nevo' ),
					'before' 	=> __( 'Before Content', 'nevo' ),
					'after' 	=> __( 'After Header', 'nevo' ),
				),
			),
			
			array(
				'name'            => $section . 'one_containers_padding',
				'type'            => 'css_ruler',
				'section'         => $section,
				'title'           => __( 'Padding', 'nevo' ),
				'device_settings' => true,
				'css_format'      => array(
					'top'    => 'padding-top: {{value}};',
					'right'  => 'padding-right: {{value}};',
					'bottom' => 'padding-bottom: {{value}};',
					'left'   => 'padding-left: {{value}};',
				),
				'selector'        => 'body.single-product .one-container .site-main .inside-page-header',
				'required'   => array(
					array( 'content_layout', '=', 'one-container' ),
					array( $section . '_page_header_display', '=', 'before' )
				),
			),
				
			array(
				'name'             => $section . '_page_header_elements',
				'type'             => 'repeater',
				'section'          => $section,
				'selector'         => 'body.single-product .page-header',
				'title'            => __( 'Elements', 'nevo' ),
				'description'      => __( 'Drag and drop to reorder.', 'nevo' ),
				'live_title_field' => 'title',
				'addable'          => false,
				'title_only'       => true,
				'default'          => apply_filters(
					'nevo_page_header_single_elements', array(
						array(
							'title' 	=> 'Breadcrumb',
							'elements'  => 'breadcrumb',
						),
						array(
							'title' 	=> 'Title',
							'elements'  => 'title',
							'_visibility' => 'hidden',
						)
					),
				),
				'fields'           => array(
					array(
						'name'  => 'title',
						'type'  => 'hidden',
						'label' => __( 'Title', 'nevo' ),
					),
					array(
						'name' => 'elements',
						'type' => 'hidden',
					),
					
				),
			),
			
			array(
				'name'            => $section . '_page_header_background_image',
				'type'            => 'select',
				'section'         => $section,
				'device_settings' => false,
				'selector'        => 'body.single-product .page-header',
				'default'         => 'global',
				'render_callback' => 'nevo_page_header_section',
				'label'           => __( 'Background image', 'nevo' ),
				'choices'         => array(
					'global' 	=> __( 'Global', 'nevo' ),
					'custom' 	=> __( 'Custom', 'nevo' ),
					'thumbnail' => __( 'Featured image', 'nevo' ),
				),
			),
			
			array(
				'name'       => $section . '_page_header_style',
				'type'       => 'modal',
				'priority'   => 25,
				'section'    => $section,
				'title'      => __( 'Page Header Styling', 'nevo' ),
				'selector'   => 'body.single-product .page-header',
				'css_format' => 'styling',
				'fields'     => array(
					'tabs'          => array(
						'normal' => __( 'Normal', 'nevo' ),
					),
					'normal_fields' => array(
						array(
							'name'       => $section . '_text_color',
							'type'       => 'color',
							'label'      => __( 'Color', 'nevo' ),
							'default'    => '#ffffff',
							'selector'   => 'body.single-product .page-header .inside-page-header, body.single-product .page-header .entry-title, body.single-product .page-header .entry-meta',
							'css_format' => 'color: {{value}}; text-decoration-color: {{value}};',
						),
						array(
							'name'       => $section . '_link_color',
							'type'       => 'color',
							'label'      => __( 'Link Color', 'nevo' ),
							'default'    => '#ffffff',
							'selector'   => 'body.single-product .page-header .inside-page-header a',
							'css_format' => 'color: {{value}}; text-decoration-color: {{value}};',
						),
						array(
							'name'       => $section . '_hover_link_color',
							'type'       => 'color',
							'label'      => __( 'Link Color Hover', 'nevo' ),
							'default'    => '#ffffff',
							'selector'   => 'body.single-product .page-header .inside-page-header a:hover, body.single-product .page-header .inside-page-header a:focus',
							'css_format' => 'color: {{value}}; text-decoration-color: {{value}};',
						),
						
						array(
							'name'            => $section . '_page_header_align',
							'type'            => 'text_align_no_justify',
							'device_settings' => true,
							'selector'   	  => "body.single-product .page-header .inside-page-header",
							'css_format'      => 'text-align: {{value}};',
							'label'           => __( 'Align', 'nevo' ),
						),
						array(
							'name'  => $section . '_bg_heading',
							'type'  => 'heading',
							'label' => __( 'Background', 'nevo' ),
						),
						
						array(
							'name'       => $section . '_bg_color',
							'type'       => 'color',
							'label'      => __( 'Background Color', 'nevo' ),
							'selector'   => 'body.single-product .page-header',
							'css_format' => 'background-color: {{value}};',
						),
						array(
							'name'       => $section . '_bg_overlay_color',
							'type'       => 'color',
							'label'      => __( 'Background overlay color', 'nevo' ),
							'selector'   => 'body.single-product .page-header:before',
							'css_format' => 'background-color: {{value}};',
						),
						array(
							'name'       => $section . '_bg_image',
							'type'       => 'image',
							'label'      => __( 'Background Image', 'nevo' ),
							'selector'   => 'body.single-product .page-header',
							'css_format' => 'background-image: url("{{value}}");',
							'device_settings' => false,
						),
						array(
							'name'       => $section . '_bg_cover',
							'type'       => 'select',
							'default'    => 'cover',
							'choices'    => array(
								''        => __( 'Default', 'nevo' ),
								'auto'    => __( 'Auto', 'nevo' ),
								'cover'   => __( 'Cover', 'nevo' ),
								'contain' => __( 'Contain', 'nevo' ),
							),
							'label'      => __( 'Size', 'nevo' ),
							'class'      => 'field-half-left',
							'selector'   => 'body.single-product .page-header',
							'css_format' => '-webkit-background-size: {{value}}; -moz-background-size: {{value}}; -o-background-size: {{value}}; background-size: {{value}};',
							'required'   => array( $section . '_bg_image', 'not_empty', '' ),
						),
						array(
							'name'       => $section . '_bg_position',
							'type'       => 'select',
							'label'      => __( 'Position', 'nevo' ),
							'class'      => 'field-half-right',
							'default'    => 'center',
							'choices'    => array(
								''              => __( 'Default', 'nevo' ),
								'center'        => __( 'Center', 'nevo' ),
								'top left'      => __( 'Top Left', 'nevo' ),
								'top right'     => __( 'Top Right', 'nevo' ),
								'top center'    => __( 'Top Center', 'nevo' ),
								'bottom left'   => __( 'Bottom Left', 'nevo' ),
								'bottom center' => __( 'Bottom Center', 'nevo' ),
								'bottom right'  => __( 'Bottom Right', 'nevo' ),
							),
							'selector'   => 'body.single-product .page-header',
							'css_format' => 'background-position: {{value}};',
							'required'   => array( $section . '_bg_image', 'not_empty', '' ),
						),
						array(
							'name'       => $section . '_bg_repeat',
							'type'       => 'select',
							'label'      => __( 'Repeat', 'nevo' ),
							'class'      => 'field-half-left',
							'default'    => 'no-repeat',
							'choices'    => array(
								'repeat'    => __( 'Default', 'nevo' ),
								'no-repeat' => __( 'No repeat', 'nevo' ),
								'repeat-x'  => __( 'Repeat horizontal', 'nevo' ),
								'repeat-y'  => __( 'Repeat vertical', 'nevo' ),
							),
							'selector'   => 'body.single-product .page-header',
							'css_format' => 'background-repeat: {{value}};',
							'required'   => array( $section . '_bg_image', 'not_empty', '' ),
						),

						array(
							'name'       => $section . '_bg_attachment',
							'type'       => 'select',
							'label'      => __( 'Attachment', 'nevo' ),
							'class'      => 'field-half-right',
							'choices'    => array(
								''       => __( 'Default', 'nevo' ),
								'scroll' => __( 'Scroll', 'nevo' ),
								'fixed'  => __( 'Fixed', 'nevo' ),
							),
							'selector'   => 'body.single-product .page-header',
							'css_format' => 'background-attachment: {{value}};',
							'required'   => array( $section . '_bg_image', 'not_empty', '' ),
						),
					),
				),
			),
			
			array(
				'name'    => $name . '_h_content',
				'type'    => 'heading',
				'section' => $section,
				'priority' => 45,
				'title'   => __( 'Content / Sidebar', 'nevo' ),
			),
			
			array(
				'name'    => $name . '_sidebar_layout',
				'type'    => 'image_select',
				'priority' => 50,
				'default' => 'no-sidebar',
				'section' => $section,
				'title'   => __( 'Sidebar Layout', 'nevo' ),
				'choices' => nevo_get_sidebar_layouts(),
			),
			
			array(
				'name'    => $name . '_h_product_tabs',
				'type'    => 'heading',
				'section' => $section,
				'priority' => 100,
				'title'   => __( 'Product Tabs', 'nevo' ),
			),
			
			array(
				'name'            => $name . '_tabs',
				'type'            => 'select',
				'section'         => $section,
				'priority' 		  => 105,
				'default'         => 'normal',
				'choices'         => array(
					'normal'    => __( 'Normal', 'nevo' ),
					'accordion' => __( 'Accordion', 'nevo' ),
				),
				'selector'        => '.woocommerce-tabs',
				//'render_callback' => 'nevo_output_product_data_tabs',
				'label'           => __( 'Product Tabs Type', 'nevo' ),
			),
			
			array(
				'name'            => $name . '_tabs_description',
				'type'            => 'checkbox',
				'default'   	  => 0,
				'section'         => $section,
				'priority' 		  => 110,
				'checkbox_label'  => __( 'Show description Heading', 'nevo' ),
				'selector'        => '.woocommerce-tabs',
				//'render_callback' => 'nevo_output_product_data_tabs',
			),
			
			array(
				'name'            => $name . '_tabs_information',
				'type'            => 'checkbox',
				'default'   	  => 0,
				'section'         => $section,
				'priority' 		  => 115,
				'checkbox_label'  => __( 'Show Information Heading', 'nevo' ),
				'selector'        => '.woocommerce-tabs',
				//'render_callback' => 'nevo_output_product_data_tabs',
			),
			
			array(
				'name'    => $name . '_h_product_related',
				'type'    => 'heading',
				'section' => $section,
				'priority' => 120,
				'title'   => __( 'Related & Upsells', 'nevo' ),
			),
			
			array(
				'name'            => $name . '_related',
				'type'            => 'checkbox',
				'default'   	  => 1,
				'section'         => $section,
				'priority' 		  => 125,
				'checkbox_label'  => __( 'Show Related Product', 'nevo' ),
				'selector'        => $selector,
			),
			
			array(
				'name'            => $name . '_related_number',
				'type'            => 'text',
				'section'         => $section,
				'priority' 		  => 130,
				'selector'        => $selector,
				'default'         => 4,
				'label'           => __( 'Related Total Products', 'nevo' ),
			),
			
			array(
				'name'            => $name . '_related_col',
				'type'            => 'select',
				'section'         => $section,
				'priority' 		  => 135,
				'default'         => 4,
				'device_settings' => false,
				'selector'        => $selector,
				'label'           => __( 'Related Columns', 'nevo' ),
				'choices'         => array(
					1 => 1,
					2 => 2,
					3 => 3,
					4 => 4,
					5 => 5,
					6 => 6,
				),
			),
			
			array(
				'name'            => $name . '_upsells',
				'type'            => 'checkbox',
				'default'   	  => 1,
				'section'         => $section,
				'priority' 		  => 140,
				'checkbox_label'  => __( 'Show Upsells Product', 'nevo' ),
				'selector'        => $selector,
			),
			
			array(
				'name'            => $name . '_upsells_col',
				'type'            => 'select',
				'section'         => $section,
				'priority' 		  => 145,
				'default'         => 4,
				'device_settings' => false,
				'selector'        => $selector,
				'label'           => __( 'Upsells Columns', 'nevo' ),
				'choices'         => array(
					1 => 1,
					2 => 2,
					3 => 3,
					4 => 4,
					5 => 5,
					6 => 6,
				),
			),
		);

		return array_merge( $configs, $config );
	}
}
add_filter( 'nevo/customizer/config', 'nevo_customizer_product_single_config', 399 );