<?php
/**
 * The template for displaying search forms in Generate
 *
 * @package Nevo
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>
<form method="get" class="search-form d-flex align-items-center flex-nowrap position-relative cv-col-12" action="<?php echo esc_url( home_url( '/' ) ); ?>">
	<label class="cv-col-12">
		<span class="screen-reader-text"><?php echo apply_filters( 'nevo_search_label', _x( 'Search for:', 'label', 'nevo' ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></span>
		<input type="search" class="search-field cv-col-12" placeholder="<?php echo esc_attr( apply_filters( 'nevo_search_placeholder', _x( 'Search &hellip;', 'placeholder', 'nevo' ) ) ); ?>" value="<?php echo esc_attr( get_search_query() ); ?>" name="s" title="<?php echo esc_attr( apply_filters( 'nevo_search_label', _x( 'Search for:', 'label', 'nevo' ) ) ); ?>">
	</label>
	<?php
	if ( apply_filters( 'nevo_search_button_icon', true ) ) {
		printf(
			'<button class="search-submit position-absolute" aria-label="%1$s">%2$s</button>',
			esc_attr( apply_filters( 'nevo_search_button', _x( 'Search', 'submit button', 'nevo' ) ) ),
			'<span class="nevo-icon">'. nevo_get_svg_icon( 'ui', 'bi-search', '', 20 ) .'</span>' // phpcs:ignore -- Escaping not necessary here.
		);
	} else {
		printf(
			'<input type="submit" class="search-submit position-absolute" value="%s">',
			apply_filters( 'nevo_search_button', _x( 'Search', 'submit button', 'nevo' ) ) // phpcs:ignore -- Escaping not necessary here.
		);
	}
	?>
</form>
