<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package Nevo
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
$sidebar = apply_filters( 'nevo_default_sidebar_left', 'sidebar-2' );
?>
<div <?php nevo_do_attr( 'left_sidebar' ); ?>>
	<div class="inside-left-sidebar inside-sidebar">
		<?php
		/**
		 * nevo_before_left_sidebar_content hook.
		 *
		 * @since 0.1
		 */
		do_action( 'nevo_before_left_sidebar_content' );

		if ( ! dynamic_sidebar( $sidebar ) ) {
			nevo_default_sidebar_widgets( 'left-sidebar' );
		}

		/**
		 * nevo_after_left_sidebar_content hook.
		 *
		 * @since 0.1
		 */
		do_action( 'nevo_after_left_sidebar_content' );
		?>
	</div>
</div>
