<?php
/**
 * Template part for displaying Cart
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Nevo
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
if ( ! Nevo()->is_woocommerce_active() ) {
	return;
}
$cart_text = Nevo()->get_setting( 'header_cart_text_label' );
$cart_total = Nevo()->get_setting( 'header_cart_sub_total' );
$text = Nevo()->get_setting( 'header_cart_text' );
$icon = Nevo()->get_setting( 'header_cart_icon' );
$size = Nevo()->get_setting( 'header_cart_size' );
$icon = wp_parse_args(
	$icon,
	array(
		'type' => '',
		'icon' => '',
	)
);
$size = wp_parse_args(
	$size,
	array(
		'unit' => '',
		'value' => '20',
	)
);

$sub_total = WC()->cart->get_cart_subtotal();
$quantities = WC()->cart->get_cart_item_quantities();
$qty   = array_sum( $quantities );
$link = get_permalink( wc_get_page_id( 'cart' ) );

$html_text = '';
if ( $cart_text ) {
	$html_text .= '<span class="cart-text d-none d-lg-block">'. sanitize_text_field( $text );
}
if ( $cart_total && $cart_text ) {
	$html_text .= ' <span class="nevo-cart-subtotal">' . $sub_total . '</span>';
} elseif ( $cart_total ) {
	$html_text .= '<span class="cart-text d-none d-lg-block"><span class="nevo-cart-subtotal">' . $sub_total . '</span></span>';
}
if ( $cart_text ) {
	$html_text .= '</span>';
}

$html_icon = '';
if ( $icon['icon'] ) {
	$html_icon = '<span class="cart-icon d-inline-flex align-self-center">'. nevo_get_svg_icon( 'ui', '' . esc_attr( $icon['icon'] ) . '', '', esc_attr( $size['value'] ) ) .'</span>';
}
$html = $html_text . $html_icon;

echo '<div class="header-min-cart builder-item-focus" data-section="header_cart">';
echo '<div class="cart-toggle position-relative">';
echo '<a href="' . esc_url( $link ) . '" class="cart-contents d-flex align-items-center">';
echo $html; // WPCS: XSS OK.
echo '</a>';
echo '<span class="cart-count bg-warning">'. $qty .'</span>';
		
echo '</div>';

	the_widget( 'WC_Widget_Cart', 'title=' );
	if ( is_customize_preview() ) {
		echo '<span class="customize-partial-edit">'. esc_html__( 'Cart', 'nevo' ) .'</span>';
	}
echo '</div>';