<?php
/**
 * Template part for displaying primary menu
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Nevo
 */
 
// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;
?>
<nav <?php nevo_do_attr( 'primary_navigation' ); ?>>
	<?php
	wp_nav_menu(
		array(
			'theme_location' 	=> 'primary',
			'container'       	=> false,
			'container_class' 	=> false,
			'container_id'    	=> false,
			'menu_class' 		=> 'nevo-nav-menu menu-primary',
			'fallback_cb' 		=> 'nevo_menu_fallback',
		)
	);
	if ( is_customize_preview() ) {
		echo '<span class="customize-partial-edit">'. esc_html__( 'Primary Menu', 'nevo' ) .'</span>';
	}
	?>
</nav>