<?php
/**
 * Template part for displaying Social
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Nevo
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>
<div class="header-search search-dropdown nevo-dropdown builder-item-focus" data-section="header_search">
	<button class="search-button nevo-toggle d-inline-flex align-self-center" aria-expanded="true">
		<span class="nevo-icon search-icon" aria-hidden="true"><?php echo nevo_get_svg_icon( 'ui', 'bi-search', '', 20 ); ?></span><span class="screen-reader-text"><?php esc_html_e( 'Search', 'nevo' ); ?></span>
	</button>
	<div class="sub-dropdown"><?php get_search_form(); ?></div><?php 
	if ( is_customize_preview() ) {
		echo '<span class="customize-partial-edit">Search Icon</span>';
	} ?>
</div>