<?php
/**
 * Template part for displaying Social
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Nevo
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$items        = Nevo()->get_setting( 'social_icons_items' );
$label 		  = Nevo()->get_setting( 'social_icons_label', 'all' );
$target_blank = Nevo()->get_setting( 'social_icons_target' );
$classes 	  = nevo_create_visibility_classes( $label, 'd' );

$rel = ' rel="noopener noreferrer" ';

$target = '_self';
if ( 1 == $target_blank ) {
	$target = '_blank';
}
$step = ' ';

if ( ! empty( $items ) ) {

	echo '<div class="header-social-icons social-general builder-item-focus" data-section="social_icons">';
	foreach ( (array) $items as $index => $item ) {
		$item = wp_parse_args(
			$item,
			array(
				'title'       => '',
				'type'        => '',
				'icon'        => '',
				'image'       => '',
				'url'         => '',
				'size'        => '',
				'_visibility' => '',
			)
		);

		if ( 'hidden' !== $item['_visibility'] ) {
			if ( ! $item['url'] ) {
				$item['url'] = '#';
			}

			$icon = wp_parse_args(
				$item['icon'],
				array(
					'type' => '',
					'icon' => '',
				)
			);
			$size = wp_parse_args(
				$item['size'],
				array(
					'unit' => '',
					'value' => '',
				)
			);

			if ( $item['url'] ) {
				echo '<a class="social-icons d-flex align-items-center justify-content-center social-' . str_replace(
					array( ' ', 'fa-fa' ),
					array(
						'-',
						'icon',
					),
					esc_attr( $icon['icon'] )
				) .'"'. $rel . 'target="' . esc_attr( $target ) . '" href="' . esc_url( $item['url'] ) . '" aria-label="' . esc_attr( $item['title'] ) . '">';
			}

			if ( 'icon' === $item['type'] && $icon['icon'] ) {
				echo '<span class="' . esc_attr( $icon['icon'] ) . ' d-inline-flex align-self-center" title="' . esc_attr( $item['title'] ) . '">'. nevo_get_svg_icon( 'ui', '' . esc_attr( $icon['icon'] ) . '', 'ms-3', esc_attr( $size['value'] ) ) .'</span>';
			}
			if ( 'image' === $item['type'] && Nevo()->get_media( $item['image'] ) ) {
				echo '<img class="social-icon-image" loading="lazy" src="'. esc_url( Nevo()->get_media( $item['image'] ) ) .'" alt="' . esc_attr( $item['title'] ) . '" style="max-width:'. esc_attr( $size['value'] ) .'px">';
			}
			if ( $label && $item['title'] ) {
				echo '<span class="social-label '. esc_attr( $classes ) .'">'. esc_attr( $item['title'] ) .'</span>';
			}
			if ( $item['url'] ) {
				echo '</a>';
			}
		}
	}
	if ( is_customize_preview() ) {
		echo '<span class="customize-partial-edit">'. esc_html__( 'Social Icons', 'nevo' ) .'</span>';
	}
	echo '</div>';
}