<?php
/**
 * Template part for displaying site tagline
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Nevo
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

// Get the title and tagline.
$title = get_bloginfo( 'title' );
$tagline = get_bloginfo( 'description' );

// If the disable title checkbox is checked, or the title field is empty, return true.
$disable_title = ( 'no' == Nevo()->get_setting( 'header_logo_name' ) || '' == $title ) ? true : false; // phpcs:ignore

// If the disable tagline checkbox is checked, or the tagline field is empty, return true.
$disable_tagline = ( 'no' == Nevo()->get_setting( 'header_logo_desc' ) || '' == $tagline ) ? true : false;  // phpcs:ignore

$schema_type = nevo_get_schema_type();

// Build our site title.
$site_title = apply_filters(
	'nevo_site_title_output',
	sprintf(
		'<%1$s class="main-title"%4$s>
			<a href="%2$s" rel="home">
				%3$s
			</a>
		</%1$s>',
		( is_front_page() && is_home() ) ? 'h1' : 'p',
		esc_url( apply_filters( 'nevo_site_title_href', home_url( '/' ) ) ),
		get_bloginfo( 'name' ),
		'microdata' === nevo_get_schema_type() ? ' itemprop="headline"' : ''
	)
);

// Build our tagline.
$site_tagline = apply_filters(
	'nevo_site_description_output',
	sprintf(
		'<p class="site-description"%2$s>
			%1$s
		</p>',
		html_entity_decode( get_bloginfo( 'description', 'display' ) ), // phpcs:ignore
		'microdata' === nevo_get_schema_type() ? ' itemprop="description"' : ''
	)
);

// Site title and tagline.
echo '<div class="site-branding builder-item-focus" data-section="title_tagline">';
	nevo_construct_logo();

	// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- outputting site title and tagline. False positive.
	echo apply_filters(
		'nevo_site_branding_output',
		sprintf(
			'<div class="site-branding-text">
				%1$s
				%2$s
			</div>',
			( ! $disable_title ) ? $site_title : '',
			( ! $disable_tagline ) ? $site_tagline : ''
		)
	);
	if ( is_customize_preview() ) {
		echo '<span class="customize-partial-edit">Site Identity</span>';
	}
echo '</div>';